#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.bin_response import BinResponse

class AnomalyAssessmentPreviewResponse(APIObject):
    """
    Attributes
    ----------
    backtest:bool, date, datetime, dict, float, int, list, str, none_type
         The backtest of the record.
    end_date:datetime
         ISO-formatted last timestamp in the subset. For example: ``2019-08-30T00:00:00.000000Z``.
    model_id:str
         The model ID of the record.
    preview_bins:[BinResponse]
         Aggregated predictions for the subset. Bins boundaries may differ from actual start/end dates because this is an aggregation.
    project_id:str
         The project ID of the record.
    record_id:str
         The ID of the anomaly assessment record.
    series_id:str, none_type
         The series id of the record. Applicable in multiseries projects
    source:str
         The source of the record
    start_date:datetime
         ISO-formatted first timestamp in the subset. For example: ``2019-08-01T00:00:00.000000Z``.
    """
    _converter = t.Dict(
        {
            t.Key("backtest"):  t.Any(),
            t.Key("end_date"):  t.DateTime(),
            t.Key("model_id"):  t.String(),
            t.Key("preview_bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
            t.Key("record_id"):  t.String(),
            t.Key("series_id"):  t.String(),
            t.Key("source"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest,
        end_date,
        model_id,
        preview_bins,
        project_id,
        record_id,
        series_id,
        source,
        start_date,
    ):
        self.backtest = backtest
        self.end_date = end_date
        self.model_id = model_id
        self.preview_bins = preview_bins
        self.project_id = project_id
        self.record_id = record_id
        self.series_id = series_id
        self.source = source
        self.start_date = start_date

    def __repr__(self):
        return (
            "AnomalyAssessmentPreviewResponse("
            "backtest={0.backtest}, "
            "end_date={0.end_date}, "
            "model_id={0.model_id}, "
            "preview_bins={0.preview_bins}, "
            "project_id={0.project_id}, "
            "record_id={0.record_id}, "
            "series_id={0.series_id}, "
            "source={0.source}, "
            "start_date={0.start_date}, "
        ).format(self)
