#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AnomalyAssessmentRecordResponse(APIObject):
    """
    Attributes
    ----------
    backtest:bool, date, datetime, dict, float, int, list, str, none_type
         The backtest of the record.
    delete_location:str, none_type
         URL to delete anomaly assessment record.
    end_date:datetime, none_type
         ISO-formatted last timestamp in the subset. For example: ``2019-08-30T00:00:00.000000Z``.
    latest_explanations_location:str, none_type
         URL to retrieve the latest predictions with the shap explanations.
    model_id:str
         The model ID of the record.
    prediction_threshold:float, none_type
         The threshold, all rows with anomaly scores greater or equal to it have Shapley explanations computed.
    preview_location:str, none_type
         URL to retrieve predictions preview for the record.
    project_id:str
         The project ID of the record.
    record_id:str
         The ID of the anomaly assessment record.
    series_id:str, none_type
         The series id of the record. Applicable in multiseries projects
    source:str
         The source of the record
    start_date:datetime, none_type
         ISO-formatted first timestamp in the subset. For example: ``2019-08-01T00:00:00.000000Z``.
    status:str
         The status of the anomaly assessment record.
    status_details:str
         The status details.
    """
    _converter = t.Dict(
        {
            t.Key("backtest"):  t.Any(),
            t.Key("delete_location"):  t.String(),
            t.Key("end_date"):  t.DateTime(),
            t.Key("latest_explanations_location"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("preview_location"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("record_id"):  t.String(),
            t.Key("series_id"):  t.String(),
            t.Key("source"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
            t.Key("status"):  t.String(),
            t.Key("status_details"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest,
        delete_location,
        end_date,
        latest_explanations_location,
        model_id,
        prediction_threshold,
        preview_location,
        project_id,
        record_id,
        series_id,
        source,
        start_date,
        status,
        status_details,
    ):
        self.backtest = backtest
        self.delete_location = delete_location
        self.end_date = end_date
        self.latest_explanations_location = latest_explanations_location
        self.model_id = model_id
        self.prediction_threshold = prediction_threshold
        self.preview_location = preview_location
        self.project_id = project_id
        self.record_id = record_id
        self.series_id = series_id
        self.source = source
        self.start_date = start_date
        self.status = status
        self.status_details = status_details

    def __repr__(self):
        return (
            "AnomalyAssessmentRecordResponse("
            "backtest={0.backtest}, "
            "delete_location={0.delete_location}, "
            "end_date={0.end_date}, "
            "latest_explanations_location={0.latest_explanations_location}, "
            "model_id={0.model_id}, "
            "prediction_threshold={0.prediction_threshold}, "
            "preview_location={0.preview_location}, "
            "project_id={0.project_id}, "
            "record_id={0.record_id}, "
            "series_id={0.series_id}, "
            "source={0.source}, "
            "start_date={0.start_date}, "
            "status={0.status}, "
            "status_details={0.status_details}, "
        ).format(self)
