#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AnomalyInsightTableData(APIObject):
    """
    Attributes
    ----------
    columns:[str]
         array of columns that contain columns from training dataset and `anomalyScore` column.
    data:[float]
         array of arrays with actual data. Order in each array corresponds to order in columns array.
    row_id:[int]
         index 0-based array. Each rowId corresponds to the actual row number of training data
    """
    _converter = t.Dict(
        {
            t.Key("columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_id"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        columns,
        data,
        row_id,
    ):
        self.columns = columns
        self.data = data
        self.row_id = row_id

    def __repr__(self):
        return (
            "AnomalyInsightTableData("
            "columns={0.columns}, "
            "data={0.data}, "
            "row_id={0.row_id}, "
        ).format(self)
