#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.anomaly_insight_table_data import AnomalyInsightTableData

class AnomalyInsightTableRetrieve(APIObject):
    """
    Attributes
    ----------
    model_id:str
         given model identifier
    table:[AnomalyInsightTableData]
         anomaly insights table
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("table"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        table,
    ):
        self.model_id = model_id
        self.table = table

    def __repr__(self):
        return (
            "AnomalyInsightTableRetrieve("
            "model_id={0.model_id}, "
            "table={0.table}, "
        ).format(self)
