#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.accuracy_over_time_plots_status import AccuracyOverTimePlotsStatus
from datarobot.models.full_api.generated.model.datetime_trend_plots_backtest_metadata import DatetimeTrendPlotsBacktestMetadata

class AnomalyOverTimePlotsMetadataResponse(APIObject):
    """
    Attributes
    ----------
    backtest_metadata:[DatetimeTrendPlotsBacktestMetadata]
         An array of metadata information for each backtest. The array index of metadata object is the backtest index.
    backtest_statuses:[AccuracyOverTimePlotsStatus]
         An array of status information for each backtest. The array index of status object is the backtest index.
    holdout_metadata:DatetimeTrendPlotsBacktestMetadata
        
    holdout_statuses:AccuracyOverTimePlotsStatus
        
    resolutions:[str]
         An array of available time resolutions for which plots can be retrieved.
    """
    _converter = t.Dict(
        {
            t.Key("backtest_metadata"):  t.List(t.Dict().allow_extra("*")),
            t.Key("backtest_statuses"):  t.List(t.Dict().allow_extra("*")),
            t.Key("holdout_metadata"):  t.Any(),
            t.Key("holdout_statuses"):  t.Any(),
            t.Key("resolutions"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest_metadata,
        backtest_statuses,
        holdout_metadata,
        holdout_statuses,
        resolutions,
    ):
        self.backtest_metadata = backtest_metadata
        self.backtest_statuses = backtest_statuses
        self.holdout_metadata = holdout_metadata
        self.holdout_statuses = holdout_statuses
        self.resolutions = resolutions

    def __repr__(self):
        return (
            "AnomalyOverTimePlotsMetadataResponse("
            "backtest_metadata={0.backtest_metadata}, "
            "backtest_statuses={0.backtest_statuses}, "
            "holdout_metadata={0.holdout_metadata}, "
            "holdout_statuses={0.holdout_statuses}, "
            "resolutions={0.resolutions}, "
        ).format(self)
