#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.anomaly_over_time_plots_preview_bins import AnomalyOverTimePlotsPreviewBins

class AnomalyOverTimePlotsPreviewResponse(APIObject):
    """
    Attributes
    ----------
    bins:[AnomalyOverTimePlotsPreviewBins]
         An array of bins for the retrieved plots.
    end_date:datetime
         The datetime of the end of the chart data (exclusive). 
    prediction_threshold:float
         Only bins with predictions exceeding this threshold are returned in the response.
    start_date:datetime
         The datetime of the start of the chart data (inclusive). 
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("end_date"):  t.DateTime(),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        end_date,
        prediction_threshold,
        start_date,
    ):
        self.bins = bins
        self.end_date = end_date
        self.prediction_threshold = prediction_threshold
        self.start_date = start_date

    def __repr__(self):
        return (
            "AnomalyOverTimePlotsPreviewResponse("
            "bins={0.bins}, "
            "end_date={0.end_date}, "
            "prediction_threshold={0.prediction_threshold}, "
            "start_date={0.start_date}, "
        ).format(self)
