#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.aot_chart_metadata_dataset_metadata import AOTChartMetadataDatasetMetadata

class AOTChartMetadataResponse(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The dataset id which was used to compute the AOT chart.
    dataset_metadata:AOTChartMetadataDatasetMetadata
        
    frequency_type:str
         How to interpret the frequency attribute of each datetimeTrendBin. One of ['rowCount', 'weightedRowCount', 'exposure', 'weightedExposure'].
    metric_name:str
         The metric used to score each bin and the calculate the metric attribute of each datetimeTrendBin.
    model_id:str
         The model id which was used to compute the AOT chart.
    project_id:str
         The project id which was used to compute the AOT chart.
    resolutions:[str]
         Suggested time resolutions where a resolution is one of ['milliseconds', 'seconds', 'minutes', 'hours', 'days', 'weeks', 'months', 'years'].
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_metadata"):  t.Any(),
            t.Key("frequency_type"):  t.String(),
            t.Key("metric_name"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("resolutions"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        dataset_metadata,
        frequency_type,
        metric_name,
        model_id,
        project_id,
        resolutions,
    ):
        self.dataset_id = dataset_id
        self.dataset_metadata = dataset_metadata
        self.frequency_type = frequency_type
        self.metric_name = metric_name
        self.model_id = model_id
        self.project_id = project_id
        self.resolutions = resolutions

    def __repr__(self):
        return (
            "AOTChartMetadataResponse("
            "dataset_id={0.dataset_id}, "
            "dataset_metadata={0.dataset_metadata}, "
            "frequency_type={0.frequency_type}, "
            "metric_name={0.metric_name}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "resolutions={0.resolutions}, "
        ).format(self)
