#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.aot_chart_bins import AOTChartBins

class AOTChartPreviewResponse(APIObject):
    """
    Attributes
    ----------
    bins:[AOTChartBins]
         The datetime chart data for that source.
    dataset_id:str
         The dataset id which was used to compute the AOT chart.
    model_id:str
         The model id which was used to compute the AOT chart.
    project_id:str
         The project id which was used to compute the AOT chart.
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        dataset_id,
        model_id,
        project_id,
    ):
        self.bins = bins
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.project_id = project_id

    def __repr__(self):
        return (
            "AOTChartPreviewResponse("
            "bins={0.bins}, "
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
        ).format(self)
