#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.aot_chart_bins import AOTChartBins
from datarobot.models.full_api.generated.model.aot_chart_statistics import AOTChartStatistics

class AOTChartRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    bins:[AOTChartBins]
         The datetime chart data for that source.
    dataset_id:str
         The dataset id to which the chart data belongs.
    model_id:str
         The model id to which the chart data belongs.
    project_id:str
         The project id to which the chart data belongs.
    resolution:str
         The resolution used for binning where a resolution is one of ['milliseconds', 'seconds', 'minutes', 'hours', 'days', 'weeks', 'months', 'years'].
    statistics:AOTChartStatistics
        
    end_date:datetime [optional]
         The requested `endDate`, or, if not specified, the end date for this dataset (exclusive). Example: '2010-05-13T00:00:00.000000Z'.. 
    start_date:datetime [optional]
         The requested `startDate`, or, if not specified, the start date for this dataset. Example: '2010-05-13T00:00:00.000000Z'.. 
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("resolution"):  t.String(),
            t.Key("statistics"):  t.Any(),
            t.Key("end_date", optional=True):  t.DateTime(),
            t.Key("start_date", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        dataset_id,
        model_id,
        project_id,
        resolution,
        statistics,
        end_date=None,
        start_date=None,
    ):
        self.bins = bins
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.project_id = project_id
        self.resolution = resolution
        self.statistics = statistics
        self.end_date = end_date
        self.start_date = start_date

    def __repr__(self):
        return (
            "AOTChartRetrieveResponse("
            "bins={0.bins}, "
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "resolution={0.resolution}, "
            "statistics={0.statistics}, "
            "end_date={0.end_date}, "
            "start_date={0.start_date}, "
        ).format(self)
