#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.application_deployment import ApplicationDeployment

class Application(APIObject):
    """
    Attributes
    ----------
    application_template_type:str, none_type
         Application template type, purpose
    application_type_id:str
         The ID of the type of the application
    cloud_provider:str
         The host of this application
    created_at:str
         The timestamp when the application was created
    created_by:str
         The username of who created the application
    creator_first_name:str, none_type
         Application creator first name
    creator_last_name:str, none_type
         Application creator last name
    creator_userhash:str, none_type
         Application creator userhash
    datasets:[str]
         The list of datasets IDs associated with the application
    deactivation_status_id:str, none_type
         The ID of the status object to track the asynchronous app deactivation process status. Will be null if the app was never deactivated.
    deployment_ids:[str]
         A list of deployment IDs for this app
    deployment_name:str, none_type
         Name of the deployment
    deployment_state:str
         The state of the application deployment
    deployment_status_id:str
          The ID of the status object to track the asynchronous deployment process status
    deployments:[ApplicationDeployment]
         A list of deployment details
    description:str
         A description of the application
    id:str
         The ID of the created application
    model_deployment_id:str
         The ID of the associated model deployment
    name:str
         The name of the application
    permissions:[str]
         The list of permitted actions, which the authenticated user can perform on this application.
    pool_used:bool
         Whether the pool where used for last app deployment
    recent_events:[str]
         The list of deployment events of the application.
    updated_at:str
         The timestamp when the application was updated
    url:str, none_type
         The URL of the active application
    user_id:str
         The ID of the user which created the application
    """
    _converter = t.Dict(
        {
            t.Key("application_template_type"):  t.String(),
            t.Key("application_type_id"):  t.String(),
            t.Key("cloud_provider"):  t.String(),
            t.Key("created_at"):  t.String(),
            t.Key("created_by"):  t.String(),
            t.Key("creator_first_name"):  t.String(),
            t.Key("creator_last_name"):  t.String(),
            t.Key("creator_userhash"):  t.String(),
            t.Key("datasets"):  t.List(t.Dict().allow_extra("*")),
            t.Key("deactivation_status_id"):  t.String(),
            t.Key("deployment_ids"):  t.List(t.Dict().allow_extra("*")),
            t.Key("deployment_name"):  t.String(),
            t.Key("deployment_state"):  t.String(),
            t.Key("deployment_status_id"):  t.String(),
            t.Key("deployments"):  t.List(t.Dict().allow_extra("*")),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("model_deployment_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("permissions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("pool_used"):  t.Bool(),
            t.Key("recent_events"):  t.List(t.Dict().allow_extra("*")),
            t.Key("updated_at"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("user_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        application_template_type,
        application_type_id,
        cloud_provider,
        created_at,
        created_by,
        creator_first_name,
        creator_last_name,
        creator_userhash,
        datasets,
        deactivation_status_id,
        deployment_ids,
        deployment_name,
        deployment_state,
        deployment_status_id,
        deployments,
        description,
        id,
        model_deployment_id,
        name,
        permissions,
        pool_used,
        recent_events,
        updated_at,
        url,
        user_id,
    ):
        self.application_template_type = application_template_type
        self.application_type_id = application_type_id
        self.cloud_provider = cloud_provider
        self.created_at = created_at
        self.created_by = created_by
        self.creator_first_name = creator_first_name
        self.creator_last_name = creator_last_name
        self.creator_userhash = creator_userhash
        self.datasets = datasets
        self.deactivation_status_id = deactivation_status_id
        self.deployment_ids = deployment_ids
        self.deployment_name = deployment_name
        self.deployment_state = deployment_state
        self.deployment_status_id = deployment_status_id
        self.deployments = deployments
        self.description = description
        self.id = id
        self.model_deployment_id = model_deployment_id
        self.name = name
        self.permissions = permissions
        self.pool_used = pool_used
        self.recent_events = recent_events
        self.updated_at = updated_at
        self.url = url
        self.user_id = user_id

    def __repr__(self):
        return (
            "Application("
            "application_template_type={0.application_template_type}, "
            "application_type_id={0.application_type_id}, "
            "cloud_provider={0.cloud_provider}, "
            "created_at={0.created_at}, "
            "created_by={0.created_by}, "
            "creator_first_name={0.creator_first_name}, "
            "creator_last_name={0.creator_last_name}, "
            "creator_userhash={0.creator_userhash}, "
            "datasets={0.datasets}, "
            "deactivation_status_id={0.deactivation_status_id}, "
            "deployment_ids={0.deployment_ids}, "
            "deployment_name={0.deployment_name}, "
            "deployment_state={0.deployment_state}, "
            "deployment_status_id={0.deployment_status_id}, "
            "deployments={0.deployments}, "
            "description={0.description}, "
            "id={0.id}, "
            "model_deployment_id={0.model_deployment_id}, "
            "name={0.name}, "
            "permissions={0.permissions}, "
            "pool_used={0.pool_used}, "
            "recent_events={0.recent_events}, "
            "updated_at={0.updated_at}, "
            "url={0.url}, "
            "user_id={0.user_id}, "
        ).format(self)
