#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.application_access_permission import ApplicationAccessPermission

class ApplicationAccessControlUpdateRequest(APIObject):
    """
    Attributes
    ----------
    data:[ApplicationAccessPermission]
         An array of AccessControlPermissionValidator objects
    permissions:[ApplicationAccessPermission] [optional]
         The list of permission objects describing which users to modify access for.. 
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("permissions", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        permissions=None,
    ):
        self.data = data
        self.permissions = permissions

    def __repr__(self):
        return (
            "ApplicationAccessControlUpdateRequest("
            "data={0.data}, "
            "permissions={0.permissions}, "
        ).format(self)
