#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.application_create_sources import ApplicationCreateSources

class ApplicationCreate(APIObject):
    """
    Attributes
    ----------
    application_type_id:str [optional]
         The ID of the of application to be created.. 
    authentication_type:str, none_type [optional]
         Authentication type.  if omitted the server will use the default value of "invitedUsersOnly"
    cloud_provider:str [optional]
         The optional cloud provider.  if omitted the server will use the default value of "drcloud"
    description:str, none_type [optional]
         A description of the application being created..  if omitted the server will use the default value of ""
    model_deployment_id:str [optional]
         The ID of the model deployment. The deployed application will use this deployment to make predictions.. 
    name:str, none_type [optional]
         The name of the application to be created.. 
    purpose:str, none_type [optional]
         An optional field to describe the purpose of the application.. 
    sources:[ApplicationCreateSources] [optional]
         The sources for this application. 
    """
    _converter = t.Dict(
        {
            t.Key("application_type_id", optional=True):  t.String(),
            t.Key("authentication_type", optional=True):  t.String(),
            t.Key("cloud_provider", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("model_deployment_id", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
            t.Key("purpose", optional=True):  t.String(),
            t.Key("sources", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        application_type_id=None,
        authentication_type=None,
        cloud_provider=None,
        description=None,
        model_deployment_id=None,
        name=None,
        purpose=None,
        sources=None,
    ):
        self.application_type_id = application_type_id
        self.authentication_type = authentication_type
        self.cloud_provider = cloud_provider
        self.description = description
        self.model_deployment_id = model_deployment_id
        self.name = name
        self.purpose = purpose
        self.sources = sources

    def __repr__(self):
        return (
            "ApplicationCreate("
            "application_type_id={0.application_type_id}, "
            "authentication_type={0.authentication_type}, "
            "cloud_provider={0.cloud_provider}, "
            "description={0.description}, "
            "model_deployment_id={0.model_deployment_id}, "
            "name={0.name}, "
            "purpose={0.purpose}, "
            "sources={0.sources}, "
        ).format(self)
