#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ApplicationCreateResponse(APIObject):
    """
    Attributes
    ----------
    application_type_id:str
         The ID of the type of the application
    created_at:str
         The timestamp when the application was created
    created_by:str
         The username of who created the application
    deactivation_status_id:str, none_type
         The ID of the status object to track the asynchronous app deactivation process status. Will be null if the app was never deactivated.
    deployment_ids:[str]
         The list of model deployment IDs associated with the application
    deployment_status_id:str
         The ID of the status object to track the asynchronous deployment process status.
    id:str
         The ID of the created application
    model_deployment_id:str
         The ID of the associated model deployment
    name:str
         The name of the application
    permissions:str
         The list of permitted actions, which the authenticated user can perform on this application.
    recent_events:[str]
         The list of deployment events of the application.
    updated_at:str
         The timestamp when the application was updated
    user_id:str
         The ID of the user which created the application
    """
    _converter = t.Dict(
        {
            t.Key("application_type_id"):  t.String(),
            t.Key("created_at"):  t.String(),
            t.Key("created_by"):  t.String(),
            t.Key("deactivation_status_id"):  t.String(),
            t.Key("deployment_ids"):  t.List(t.Dict().allow_extra("*")),
            t.Key("deployment_status_id"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("model_deployment_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("permissions"):  t.String(),
            t.Key("recent_events"):  t.List(t.Dict().allow_extra("*")),
            t.Key("updated_at"):  t.String(),
            t.Key("user_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        application_type_id,
        created_at,
        created_by,
        deactivation_status_id,
        deployment_ids,
        deployment_status_id,
        id,
        model_deployment_id,
        name,
        permissions,
        recent_events,
        updated_at,
        user_id,
    ):
        self.application_type_id = application_type_id
        self.created_at = created_at
        self.created_by = created_by
        self.deactivation_status_id = deactivation_status_id
        self.deployment_ids = deployment_ids
        self.deployment_status_id = deployment_status_id
        self.id = id
        self.model_deployment_id = model_deployment_id
        self.name = name
        self.permissions = permissions
        self.recent_events = recent_events
        self.updated_at = updated_at
        self.user_id = user_id

    def __repr__(self):
        return (
            "ApplicationCreateResponse("
            "application_type_id={0.application_type_id}, "
            "created_at={0.created_at}, "
            "created_by={0.created_by}, "
            "deactivation_status_id={0.deactivation_status_id}, "
            "deployment_ids={0.deployment_ids}, "
            "deployment_status_id={0.deployment_status_id}, "
            "id={0.id}, "
            "model_deployment_id={0.model_deployment_id}, "
            "name={0.name}, "
            "permissions={0.permissions}, "
            "recent_events={0.recent_events}, "
            "updated_at={0.updated_at}, "
            "user_id={0.user_id}, "
        ).format(self)
