#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.recent_events_metadata import RecentEventsMetadata

class ApplicationRecentEvents(APIObject):
    """
    Attributes
    ----------
    event_type:str
         The type of event
    metadata:RecentEventsMetadata
        
    timestamp:datetime
         The timestamp when the event was recorded
    """
    _converter = t.Dict(
        {
            t.Key("event_type"):  t.String(),
            t.Key("metadata"):  t.Any(),
            t.Key("timestamp"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        event_type,
        metadata,
        timestamp,
    ):
        self.event_type = event_type
        self.metadata = metadata
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "ApplicationRecentEvents("
            "event_type={0.event_type}, "
            "metadata={0.metadata}, "
            "timestamp={0.timestamp}, "
        ).format(self)
