#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ApplicationSharingUpdateOrRemove(APIObject):
    """
    Attributes
    ----------
    operation:str
         Name of the action being taken. The only operation is 'updateRoles'.. defaults to "updateRoles", must be one of ["updateRoles", ]
    roles:[bool, date, datetime, dict, float, int, list, str, none_type]
         Array of GrantAccessControl objects., up to maximum 100 objects.
    note:str [optional]
         A note to go with the project share.  if omitted the server will use the default value of ""
    send_notification:bool [optional]
         Send a notification?.  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("operation"):  t.String(),
            t.Key("roles"):  t.List(t.Dict().allow_extra("*")),
            t.Key("note", optional=True):  t.String(),
            t.Key("send_notification", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        operation,
        roles,
        note=None,
        send_notification=None,
    ):
        self.operation = operation
        self.roles = roles
        self.note = note
        self.send_notification = send_notification

    def __repr__(self):
        return (
            "ApplicationSharingUpdateOrRemove("
            "operation={0.operation}, "
            "roles={0.roles}, "
            "note={0.note}, "
            "send_notification={0.send_notification}, "
        ).format(self)
