#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ApplicationTypeConfigurationDeployment(APIObject):
    """
    Attributes
    ----------
    internal_name:str
         The internal name of this deployment
    name:str
         The name of this deployment
    description:str [optional]
         A description of the deployment configuration. 
    target_types:[str] [optional]
         The type of the deployment. 
    """
    _converter = t.Dict(
        {
            t.Key("internal_name"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("target_types", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        internal_name,
        name,
        description=None,
        target_types=None,
    ):
        self.internal_name = internal_name
        self.name = name
        self.description = description
        self.target_types = target_types

    def __repr__(self):
        return (
            "ApplicationTypeConfigurationDeployment("
            "internal_name={0.internal_name}, "
            "name={0.name}, "
            "description={0.description}, "
            "target_types={0.target_types}, "
        ).format(self)
