#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.application_type_configuration import ApplicationTypeConfiguration

class ApplicationTypeRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    configuration:ApplicationTypeConfiguration
        
    demo_available:bool
         Indicates if app type has the ability to launch a demo version
    demo_dataset_link:str, none_type
         Link to demo dataset that usable with app
    description:str
         the description of the application
    id:str
         The ID of the application type
    is_launchable:bool
         Indicates if app of this type could be deployed by current user
    logo_image:str, none_type
         The logo of the application encoded as base64 string PNG image
    maturity:str
         Indicates app maturity level
    name:str
         The name of the application type
    version:str
         The version
    """
    _converter = t.Dict(
        {
            t.Key("configuration"):  t.Any(),
            t.Key("demo_available"):  t.Bool(),
            t.Key("demo_dataset_link"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_launchable"):  t.Bool(),
            t.Key("logo_image"):  t.String(),
            t.Key("maturity"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("version"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        configuration,
        demo_available,
        demo_dataset_link,
        description,
        id,
        is_launchable,
        logo_image,
        maturity,
        name,
        version,
    ):
        self.configuration = configuration
        self.demo_available = demo_available
        self.demo_dataset_link = demo_dataset_link
        self.description = description
        self.id = id
        self.is_launchable = is_launchable
        self.logo_image = logo_image
        self.maturity = maturity
        self.name = name
        self.version = version

    def __repr__(self):
        return (
            "ApplicationTypeRetrieveResponse("
            "configuration={0.configuration}, "
            "demo_available={0.demo_available}, "
            "demo_dataset_link={0.demo_dataset_link}, "
            "description={0.description}, "
            "id={0.id}, "
            "is_launchable={0.is_launchable}, "
            "logo_image={0.logo_image}, "
            "maturity={0.maturity}, "
            "name={0.name}, "
            "version={0.version}, "
        ).format(self)
