#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.application_type_usecases_source import ApplicationTypeUsecasesSource

class ApplicationTypeUsecases(APIObject):
    """
    Attributes
    ----------
    application_type_id:str
         id of application type
    demo_available:bool
         Is demo app creation available for this usecase
    description:str
         Description of this usecase
    id:str
         id of usecase
    sources:[ApplicationTypeUsecasesSource]
         List of resources linked to usecase
    title:str
         Title of usecase
    """
    _converter = t.Dict(
        {
            t.Key("application_type_id"):  t.String(),
            t.Key("demo_available"):  t.Bool(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("sources"):  t.List(t.Dict().allow_extra("*")),
            t.Key("title"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        application_type_id,
        demo_available,
        description,
        id,
        sources,
        title,
    ):
        self.application_type_id = application_type_id
        self.demo_available = demo_available
        self.description = description
        self.id = id
        self.sources = sources
        self.title = title

    def __repr__(self):
        return (
            "ApplicationTypeUsecases("
            "application_type_id={0.application_type_id}, "
            "demo_available={0.demo_available}, "
            "description={0.description}, "
            "id={0.id}, "
            "sources={0.sources}, "
            "title={0.title}, "
        ).format(self)
