#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.approval_policy_automatic_action import ApprovalPolicyAutomaticAction
from datarobot.models.full_api.generated.model.approval_policy_review import ApprovalPolicyReview
from datarobot.models.full_api.generated.model.approval_policy_trigger import ApprovalPolicyTrigger

class ApprovalPolicy(APIObject):
    """
    Attributes
    ----------
    active:bool
         Whether this policy is active.. defaults to True
    name:str
         Name of the Approval Policy.
    trigger:ApprovalPolicyTrigger
        
    automatic_action:ApprovalPolicyAutomaticAction [optional]
         
    review:ApprovalPolicyReview [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("active"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("trigger"):  t.Any(),
            t.Key("automatic_action", optional=True):  t.Any(),
            t.Key("review", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        active,
        name,
        trigger,
        automatic_action=None,
        review=None,
    ):
        self.active = active
        self.name = name
        self.trigger = trigger
        self.automatic_action = automatic_action
        self.review = review

    def __repr__(self):
        return (
            "ApprovalPolicy("
            "active={0.active}, "
            "name={0.name}, "
            "trigger={0.trigger}, "
            "automatic_action={0.automatic_action}, "
            "review={0.review}, "
        ).format(self)
