#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ApprovalPolicyIntendedActionCondition(APIObject):
    """
    Attributes
    ----------
    condition:str
         Condition for the field content to trigger on.
    field_name:str
         Name of the attribute of the entity to filter entities by. An example value is ``importance`` attribute for the deployment entity.
    values:[str], none_type
         Array of field values to apply condition to trigger on. If ``null`` for ``equals`` condition, then any value for the field is accepted.
    """
    _converter = t.Dict(
        {
            t.Key("condition"):  t.String(),
            t.Key("field_name"):  t.String(),
            t.Key("values"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        condition,
        field_name,
        values,
    ):
        self.condition = condition
        self.field_name = field_name
        self.values = values

    def __repr__(self):
        return (
            "ApprovalPolicyIntendedActionCondition("
            "condition={0.condition}, "
            "field_name={0.field_name}, "
            "values={0.values}, "
        ).format(self)
