#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ApprovalPolicyMatchResponse(APIObject):
    """
    Attributes
    ----------
    action:str
         Searched policy action.
    entity_type:str
         Searched typed of the entity.
    policy_id:str, none_type
         ID of the matching approval policy. ``null`` if no matching policies found.
    field_name:str, none_type [optional]
         Name of the entity field to filter policies by.. 
    field_value:str, none_type [optional]
         Value of the entity field to filter policies by.. 
    """
    _converter = t.Dict(
        {
            t.Key("action"):  t.String(),
            t.Key("entity_type"):  t.String(),
            t.Key("policy_id"):  t.String(),
            t.Key("field_name", optional=True):  t.String(),
            t.Key("field_value", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        action,
        entity_type,
        policy_id,
        field_name=None,
        field_value=None,
    ):
        self.action = action
        self.entity_type = entity_type
        self.policy_id = policy_id
        self.field_name = field_name
        self.field_value = field_value

    def __repr__(self):
        return (
            "ApprovalPolicyMatchResponse("
            "action={0.action}, "
            "entity_type={0.entity_type}, "
            "policy_id={0.policy_id}, "
            "field_name={0.field_name}, "
            "field_value={0.field_value}, "
        ).format(self)
