#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.approval_policy_automatic_action import ApprovalPolicyAutomaticAction
from datarobot.models.full_api.generated.model.approval_policy_review import ApprovalPolicyReview
from datarobot.models.full_api.generated.model.approval_policy_trigger import ApprovalPolicyTrigger

class ApprovalPolicyResponse(APIObject):
    """
    Attributes
    ----------
    active:bool
         Whether this policy is active.. defaults to True
    id:str
         ID of the Approval Policy.
    name:str
         Name of the Approval Policy.
    open_requests:int
         Number of open Change Requests associated with the policy.
    trigger:ApprovalPolicyTrigger
        
    automatic_action:ApprovalPolicyAutomaticAction [optional]
         
    review:ApprovalPolicyReview [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("active"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("open_requests"):  t.Int(),
            t.Key("trigger"):  t.Any(),
            t.Key("automatic_action", optional=True):  t.Any(),
            t.Key("review", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        active,
        id,
        name,
        open_requests,
        trigger,
        automatic_action=None,
        review=None,
    ):
        self.active = active
        self.id = id
        self.name = name
        self.open_requests = open_requests
        self.trigger = trigger
        self.automatic_action = automatic_action
        self.review = review

    def __repr__(self):
        return (
            "ApprovalPolicyResponse("
            "active={0.active}, "
            "id={0.id}, "
            "name={0.name}, "
            "open_requests={0.open_requests}, "
            "trigger={0.trigger}, "
            "automatic_action={0.automatic_action}, "
            "review={0.review}, "
        ).format(self)
