#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.policy_user_group import PolicyUserGroup

class ApprovalPolicyReview(APIObject):
    """
    Attributes
    ----------
    groups:[PolicyUserGroup], none_type [optional]
         A list of user groups that will be added as required reviewers on Change Requests for the entities that match the policy.. 
    reminder_period:str, none_type [optional]
         Duration period in ISO 8601 format that indicates when to send a reminder for reviewing a Change Request after its creation or last reminder if it hasn't been approved yet. If ``null``, no review reminders are sent to the reviewers.. 
    """
    _converter = t.Dict(
        {
            t.Key("groups", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("reminder_period", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        groups=None,
        reminder_period=None,
    ):
        self.groups = groups
        self.reminder_period = reminder_period

    def __repr__(self):
        return (
            "ApprovalPolicyReview("
            "groups={0.groups}, "
            "reminder_period={0.reminder_period}, "
        ).format(self)
