#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.approval_policy_intended_action import ApprovalPolicyIntendedAction
from datarobot.models.full_api.generated.model.approval_policy_trigger_label import ApprovalPolicyTriggerLabel
from datarobot.models.full_api.generated.model.policy_user_group import PolicyUserGroup

class ApprovalPolicyTrigger(APIObject):
    """
    Attributes
    ----------
    entity_type:str
         Type of entity to trigger on.
    intended_action:ApprovalPolicyIntendedAction
        
    filter_groups:[PolicyUserGroup], none_type [optional]
         A list of user groups to apply Approval Policy for. If User 'A' and User 'B' are both members of the same organisation, and User 'A' is a member of one of the groups listed in this field,but User 'B' is not, then an approval workflow will be triggerred for User 'A' on an action to the entity that matches policy condition, but not for User 'B'. If ``null``, approvals workflow will be triggered for all users.. 
    labels:ApprovalPolicyTriggerLabel [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("entity_type"):  t.String(),
            t.Key("intended_action"):  t.Any(),
            t.Key("filter_groups", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("labels", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        entity_type,
        intended_action,
        filter_groups=None,
        labels=None,
    ):
        self.entity_type = entity_type
        self.intended_action = intended_action
        self.filter_groups = filter_groups
        self.labels = labels

    def __repr__(self):
        return (
            "ApprovalPolicyTrigger("
            "entity_type={0.entity_type}, "
            "intended_action={0.intended_action}, "
            "filter_groups={0.filter_groups}, "
            "labels={0.labels}, "
        ).format(self)
