#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AssociationID(APIObject):
    """
    Attributes
    ----------
    column_names:[str], none_type
         Indicates the columns that will be used to associate actuals with predictions.
    required_in_prediction_requests:bool
         Indicates whether the association ID is required in prediction requests.
    """
    _converter = t.Dict(
        {
            t.Key("column_names"):  t.List(t.Dict().allow_extra("*")),
            t.Key("required_in_prediction_requests"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        column_names,
        required_in_prediction_requests,
    ):
        self.column_names = column_names
        self.required_in_prediction_requests = required_in_prediction_requests

    def __repr__(self):
        return (
            "AssociationID("
            "column_names={0.column_names}, "
            "required_in_prediction_requests={0.required_in_prediction_requests}, "
        ).format(self)
