#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AssociationIDUpdate(APIObject):
    """
    Attributes
    ----------
    column_names:[str], none_type [optional]
         List of column names used to represent an association id. Currently, exactly one column name may be provided.. 
    required_in_prediction_requests:bool [optional]
         Whether or not association id values are required in each prediction request for this deployment. Note that you may not change an association ID's column names after they have been set and predictions including those columns have been made . 
    """
    _converter = t.Dict(
        {
            t.Key("column_names", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("required_in_prediction_requests", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        column_names=None,
        required_in_prediction_requests=None,
    ):
        self.column_names = column_names
        self.required_in_prediction_requests = required_in_prediction_requests

    def __repr__(self):
        return (
            "AssociationIDUpdate("
            "column_names={0.column_names}, "
            "required_in_prediction_requests={0.required_in_prediction_requests}, "
        ).format(self)
