#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AuditLogContextObjectResponse(APIObject):
    """
    Attributes
    ----------
    org_id:str, none_type [optional]
         The id of the organization.. 
    org_name:str, none_type [optional]
         The name of the organization.. 
    project_name:str, none_type [optional]
         The name of the project.. 
    project_type:str, none_type [optional]
         The type of project.. 
    user_project_role:str, none_type [optional]
         The role of the user associated with this project.. 
    """
    _converter = t.Dict(
        {
            t.Key("org_id", optional=True):  t.String(),
            t.Key("org_name", optional=True):  t.String(),
            t.Key("project_name", optional=True):  t.String(),
            t.Key("project_type", optional=True):  t.String(),
            t.Key("user_project_role", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        org_id=None,
        org_name=None,
        project_name=None,
        project_type=None,
        user_project_role=None,
    ):
        self.org_id = org_id
        self.org_name = org_name
        self.project_name = project_name
        self.project_type = project_type
        self.user_project_role = user_project_role

    def __repr__(self):
        return (
            "AuditLogContextObjectResponse("
            "org_id={0.org_id}, "
            "org_name={0.org_name}, "
            "project_name={0.project_name}, "
            "project_type={0.project_type}, "
            "user_project_role={0.user_project_role}, "
        ).format(self)
