#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.audit_log_context_object_response import AuditLogContextObjectResponse

class AuditLogsRetrieveOneResponse(APIObject):
    """
    Attributes
    ----------
    context:AuditLogContextObjectResponse
        
    event:str
         The record event label, e.g. 'Start Autopilot'.
    id:str
         The record ID.
    project_id:str, none_type
         The record event project id.
    timestamp:datetime
         The record timestamp.
    user_id:str
         The user id of the record events user.
    ip:str, none_type [optional]
         The IP address of the server where the record event happened. Will be empty if ``includeIdentifyingFields`` is True.. 
    username:str, none_type [optional]
         The username of the record events user. Will be empty if ``includeIdentifyingFields`` is True.. 
    """
    _converter = t.Dict(
        {
            t.Key("context"):  t.Any(),
            t.Key("event"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("timestamp"):  t.DateTime(),
            t.Key("user_id"):  t.String(),
            t.Key("ip", optional=True):  t.String(),
            t.Key("username", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        context,
        event,
        id,
        project_id,
        timestamp,
        user_id,
        ip=None,
        username=None,
    ):
        self.context = context
        self.event = event
        self.id = id
        self.project_id = project_id
        self.timestamp = timestamp
        self.user_id = user_id
        self.ip = ip
        self.username = username

    def __repr__(self):
        return (
            "AuditLogsRetrieveOneResponse("
            "context={0.context}, "
            "event={0.event}, "
            "id={0.id}, "
            "project_id={0.project_id}, "
            "timestamp={0.timestamp}, "
            "user_id={0.user_id}, "
            "ip={0.ip}, "
            "username={0.username}, "
        ).format(self)
