#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AutomatedDocCreate(APIObject):
    """
    Attributes
    ----------
    document_type:str
         Type of the automated document you want to generate.
    entity_id:str
         ID of the entity to generate the document for. It can be a model ID, a project ID.
    output_format:str
         Format to generate the document in.
    document_type_specific_parameters:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Set parameters unique for a specific document type. Currently, only these document types can have document-specific parameters: ['DEPLOYMENT_REPORT']. 
    locale:str [optional]
         Localization of the document. Defaults to EN_US.. 
    template_id:str [optional]
         Template ID to use for the document outline. Defaults to standard Datarobot template.. 
    """
    _converter = t.Dict(
        {
            t.Key("document_type"):  t.String(),
            t.Key("entity_id"):  t.String(),
            t.Key("output_format"):  t.String(),
            t.Key("document_type_specific_parameters", optional=True):  t.Any(),
            t.Key("locale", optional=True):  t.String(),
            t.Key("template_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        document_type,
        entity_id,
        output_format,
        document_type_specific_parameters=None,
        locale=None,
        template_id=None,
    ):
        self.document_type = document_type
        self.entity_id = entity_id
        self.output_format = output_format
        self.document_type_specific_parameters = document_type_specific_parameters
        self.locale = locale
        self.template_id = template_id

    def __repr__(self):
        return (
            "AutomatedDocCreate("
            "document_type={0.document_type}, "
            "entity_id={0.entity_id}, "
            "output_format={0.output_format}, "
            "document_type_specific_parameters={0.document_type_specific_parameters}, "
            "locale={0.locale}, "
            "template_id={0.template_id}, "
        ).format(self)
