#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AutomatedDocCreateDeploymentReport(APIObject):
    """
    Attributes
    ----------
    bucket_size:str [optional]
         You can regulate the size of the buckets in charts. One bucket reflects some duration period and you can set the exact duration with this parameter. Bucket size gets defaulted to either a month, a week, or a day, based on the time range of the report. We use `ISO 8601 <https://www.digi.com/resources/documentation/digidocs/90001437-13/reference/r_iso_8601_duration_format.htm>`_ duration format to specify values.. 
    end:datetime, none_type [optional]
         RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. 
    model_id:str [optional]
         Provide a model ID to generate a report for a previously deployed model.. 
    start:datetime, none_type [optional]
         RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. 
    """
    _converter = t.Dict(
        {
            t.Key("bucket_size", optional=True):  t.String(),
            t.Key("end", optional=True):  t.DateTime(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("start", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bucket_size=None,
        end=None,
        model_id=None,
        start=None,
    ):
        self.bucket_size = bucket_size
        self.end = end
        self.model_id = model_id
        self.start = start

    def __repr__(self):
        return (
            "AutomatedDocCreateDeploymentReport("
            "bucket_size={0.bucket_size}, "
            "end={0.end}, "
            "model_id={0.model_id}, "
            "start={0.start}, "
        ).format(self)
