#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.doc_type_specific_info import DocTypeSpecificInfo

class AutomatedDocItem(APIObject):
    """
    Attributes
    ----------
    created_at:datetime
         Timestamp for the document creation time.
    document_type:str
         Type of the generated document.
    entity_id:str
         Unique identifier of the entity the document was generated for.
    id:str
         Unique identifier of the generated document.
    output_format:str
         File format of the generated document.
    template_id:str
         Unique identifier of the template used for the document outline.
    doc_type_specific_info:DocTypeSpecificInfo [optional]
         
    locale:str [optional]
         Locale of the generated document.. 
    """
    _converter = t.Dict(
        {
            t.Key("created_at"):  t.DateTime(),
            t.Key("document_type"):  t.String(),
            t.Key("entity_id"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("output_format"):  t.String(),
            t.Key("template_id"):  t.String(),
            t.Key("doc_type_specific_info", optional=True):  t.Any(),
            t.Key("locale", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_at,
        document_type,
        entity_id,
        id,
        output_format,
        template_id,
        doc_type_specific_info=None,
        locale=None,
    ):
        self.created_at = created_at
        self.document_type = document_type
        self.entity_id = entity_id
        self.id = id
        self.output_format = output_format
        self.template_id = template_id
        self.doc_type_specific_info = doc_type_specific_info
        self.locale = locale

    def __repr__(self):
        return (
            "AutomatedDocItem("
            "created_at={0.created_at}, "
            "document_type={0.document_type}, "
            "entity_id={0.entity_id}, "
            "id={0.id}, "
            "output_format={0.output_format}, "
            "template_id={0.template_id}, "
            "doc_type_specific_info={0.doc_type_specific_info}, "
            "locale={0.locale}, "
        ).format(self)
