#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AutopilotStart(APIObject):
    """
    Attributes
    ----------
    featurelist_id:str
         The ID of a featurelist that should be used for autopilot.
    autopilot_cluster_list:[int], none_type [optional]
         Optional. A list of integers where each value will be used as the number of clusters in Autopilot model(s) for unsupervised clustering projects. Cannot be specified unless unsupervisedMode is true and unsupervisedType is set to 'clustering'.. 
    blend_best_models:bool [optional]
         Blend best models during Autopilot run. This option is not supported in SHAP-only mode or for multilabel projects.. 
    consider_blenders_in_recommendation:bool [optional]
         Include blenders when selecting a model to prepare for deployment in an Autopilot Run. This option is not supported in SHAP-only mode or for multilabel projects.. 
    mode:str [optional]
         The autopilot mode..  if omitted the server will use the default value of "auto"
    prepare_model_for_deployment:bool [optional]
         Prepare model for deployment during Autopilot run. The preparation includes creating reduced feature list models, retraining best model on higher sample size, computing insights and assigning \"RECOMMENDED FOR DEPLOYMENT\" label.. 
    run_leakage_removed_feature_list:bool [optional]
         Run Autopilot on Leakage Removed feature list (if exists).. 
    scoring_code_only:bool [optional]
         Keep only models that can be converted to scorable java code during Autopilot run.. 
    """
    _converter = t.Dict(
        {
            t.Key("featurelist_id"):  t.String(),
            t.Key("autopilot_cluster_list", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("blend_best_models", optional=True):  t.Bool(),
            t.Key("consider_blenders_in_recommendation", optional=True):  t.Bool(),
            t.Key("mode", optional=True):  t.String(),
            t.Key("prepare_model_for_deployment", optional=True):  t.Bool(),
            t.Key("run_leakage_removed_feature_list", optional=True):  t.Bool(),
            t.Key("scoring_code_only", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        featurelist_id,
        autopilot_cluster_list=None,
        blend_best_models=None,
        consider_blenders_in_recommendation=None,
        mode=None,
        prepare_model_for_deployment=None,
        run_leakage_removed_feature_list=None,
        scoring_code_only=None,
    ):
        self.featurelist_id = featurelist_id
        self.autopilot_cluster_list = autopilot_cluster_list
        self.blend_best_models = blend_best_models
        self.consider_blenders_in_recommendation = consider_blenders_in_recommendation
        self.mode = mode
        self.prepare_model_for_deployment = prepare_model_for_deployment
        self.run_leakage_removed_feature_list = run_leakage_removed_feature_list
        self.scoring_code_only = scoring_code_only

    def __repr__(self):
        return (
            "AutopilotStart("
            "featurelist_id={0.featurelist_id}, "
            "autopilot_cluster_list={0.autopilot_cluster_list}, "
            "blend_best_models={0.blend_best_models}, "
            "consider_blenders_in_recommendation={0.consider_blenders_in_recommendation}, "
            "mode={0.mode}, "
            "prepare_model_for_deployment={0.prepare_model_for_deployment}, "
            "run_leakage_removed_feature_list={0.run_leakage_removed_feature_list}, "
            "scoring_code_only={0.scoring_code_only}, "
        ).format(self)
