#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Backtest(APIObject):
    """
    Attributes
    ----------
    index:int
         The index from zero of the backtest specified by this object.
    validation_start_date:datetime
         A datetime string representing the start date of the validation data for this backtest.
    gap_duration:str [optional]
         A duration string representing the duration of the gap between the training and the validation data for this backtest.. 
    primary_training_end_date:datetime [optional]
         A datetime string representing the end date of the primary training data for this backtest.. 
    primary_training_start_date:datetime [optional]
         A datetime string representing the start date of the primary training data for this backtest.. 
    validation_duration:str [optional]
         A duration string representing the duration of the validation data for this backtest.. 
    validation_end_date:datetime [optional]
         A datetime string representing the end date of the validation data for this backtest.. 
    """
    _converter = t.Dict(
        {
            t.Key("index"):  t.Int(),
            t.Key("validation_start_date"):  t.DateTime(),
            t.Key("gap_duration", optional=True):  t.String(),
            t.Key("primary_training_end_date", optional=True):  t.DateTime(),
            t.Key("primary_training_start_date", optional=True):  t.DateTime(),
            t.Key("validation_duration", optional=True):  t.String(),
            t.Key("validation_end_date", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        index,
        validation_start_date,
        gap_duration=None,
        primary_training_end_date=None,
        primary_training_start_date=None,
        validation_duration=None,
        validation_end_date=None,
    ):
        self.index = index
        self.validation_start_date = validation_start_date
        self.gap_duration = gap_duration
        self.primary_training_end_date = primary_training_end_date
        self.primary_training_start_date = primary_training_start_date
        self.validation_duration = validation_duration
        self.validation_end_date = validation_end_date

    def __repr__(self):
        return (
            "Backtest("
            "index={0.index}, "
            "validation_start_date={0.validation_start_date}, "
            "gap_duration={0.gap_duration}, "
            "primary_training_end_date={0.primary_training_end_date}, "
            "primary_training_start_date={0.primary_training_start_date}, "
            "validation_duration={0.validation_duration}, "
            "validation_end_date={0.validation_end_date}, "
        ).format(self)
