#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BacktestNewMethodForOpenApi(APIObject):
    """
    Attributes
    ----------
    index:int
         The index from zero of the backtest.
    primary_training_end_date:datetime
         A datetime string representing the end date of the primary training data for this backtest.
    primary_training_start_date:datetime
         A datetime string representing the start date of the primary training data for this backtest.
    validation_end_date:datetime
         A datetime string representing the end date of the validation data for this backtest.
    validation_start_date:datetime
         A datetime string representing the start date of the validation data for this backtest.
    """
    _converter = t.Dict(
        {
            t.Key("index"):  t.Int(),
            t.Key("primary_training_end_date"):  t.DateTime(),
            t.Key("primary_training_start_date"):  t.DateTime(),
            t.Key("validation_end_date"):  t.DateTime(),
            t.Key("validation_start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        index,
        primary_training_end_date,
        primary_training_start_date,
        validation_end_date,
        validation_start_date,
    ):
        self.index = index
        self.primary_training_end_date = primary_training_end_date
        self.primary_training_start_date = primary_training_start_date
        self.validation_end_date = validation_end_date
        self.validation_start_date = validation_start_date

    def __repr__(self):
        return (
            "BacktestNewMethodForOpenApi("
            "index={0.index}, "
            "primary_training_end_date={0.primary_training_end_date}, "
            "primary_training_start_date={0.primary_training_start_date}, "
            "validation_end_date={0.validation_end_date}, "
            "validation_start_date={0.validation_start_date}, "
        ).format(self)
