#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BacktestResponse(APIObject):
    """
    Attributes
    ----------
    available_training_duration:str
         The duration of the available training data for this backtest.
    available_training_end_date:datetime
         The end date of the available training data for this backtest.
    available_training_start_date:datetime
         The start date of the available training data for this backtest.
    gap_duration:str
         The duration of the gap between the training and the validation scoring data for this backtest.
    gap_end_date:datetime
         The end date of the gap between the training and validation scoring data for this backtest.
    gap_start_date:datetime
         The start date of the gap between the training and validation scoring data for this backtest.
    index:int
         The index from zero of this backtest.
    primary_training_duration:str
         The duration of the primary training data for this backtest.
    primary_training_end_date:datetime
         The end date of the primary training data for this backtest.
    primary_training_start_date:datetime
         The start date of the primary training data for this backtest.
    validation_duration:str
         The duration of the validation scoring data for this backtest.
    validation_end_date:datetime
         The end date of the validation scoring data for this backtest.
    validation_start_date:datetime
         The start date of the validation scoring data for this backtest.
    """
    _converter = t.Dict(
        {
            t.Key("available_training_duration"):  t.String(),
            t.Key("available_training_end_date"):  t.DateTime(),
            t.Key("available_training_start_date"):  t.DateTime(),
            t.Key("gap_duration"):  t.String(),
            t.Key("gap_end_date"):  t.DateTime(),
            t.Key("gap_start_date"):  t.DateTime(),
            t.Key("index"):  t.Int(),
            t.Key("primary_training_duration"):  t.String(),
            t.Key("primary_training_end_date"):  t.DateTime(),
            t.Key("primary_training_start_date"):  t.DateTime(),
            t.Key("validation_duration"):  t.String(),
            t.Key("validation_end_date"):  t.DateTime(),
            t.Key("validation_start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        available_training_duration,
        available_training_end_date,
        available_training_start_date,
        gap_duration,
        gap_end_date,
        gap_start_date,
        index,
        primary_training_duration,
        primary_training_end_date,
        primary_training_start_date,
        validation_duration,
        validation_end_date,
        validation_start_date,
    ):
        self.available_training_duration = available_training_duration
        self.available_training_end_date = available_training_end_date
        self.available_training_start_date = available_training_start_date
        self.gap_duration = gap_duration
        self.gap_end_date = gap_end_date
        self.gap_start_date = gap_start_date
        self.index = index
        self.primary_training_duration = primary_training_duration
        self.primary_training_end_date = primary_training_end_date
        self.primary_training_start_date = primary_training_start_date
        self.validation_duration = validation_duration
        self.validation_end_date = validation_end_date
        self.validation_start_date = validation_start_date

    def __repr__(self):
        return (
            "BacktestResponse("
            "available_training_duration={0.available_training_duration}, "
            "available_training_end_date={0.available_training_end_date}, "
            "available_training_start_date={0.available_training_start_date}, "
            "gap_duration={0.gap_duration}, "
            "gap_end_date={0.gap_end_date}, "
            "gap_start_date={0.gap_start_date}, "
            "index={0.index}, "
            "primary_training_duration={0.primary_training_duration}, "
            "primary_training_end_date={0.primary_training_end_date}, "
            "primary_training_start_date={0.primary_training_start_date}, "
            "validation_duration={0.validation_duration}, "
            "validation_end_date={0.validation_end_date}, "
            "validation_start_date={0.validation_start_date}, "
        ).format(self)
