#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BacktestStabilityPlotData(APIObject):
    """
    Attributes
    ----------
    backtest_index:int, none_type
         An integer representing the index of the backtest, starting from 0. For holdout, this field will be null.
    partition:str
         Identifier of the partition. Can either identify a specific backtest (\"backtest0\", \"backtest1\", ...) or the holdout set (\"holdout\").
    score:float, none_type
         Score for this partition. Can be null if the score is unavailable for this partition (e.g. holdout is locked or backtesting has not been run yet).
    scoring_end_date:datetime
         End date of the subset used for scoring.
    scoring_start_date:datetime
         Start date of the subset used for scoring.
    """
    _converter = t.Dict(
        {
            t.Key("backtest_index"):  t.Int(),
            t.Key("partition"):  t.String(),
            t.Key("score"):  t.Float(),
            t.Key("scoring_end_date"):  t.DateTime(),
            t.Key("scoring_start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest_index,
        partition,
        score,
        scoring_end_date,
        scoring_start_date,
    ):
        self.backtest_index = backtest_index
        self.partition = partition
        self.score = score
        self.scoring_end_date = scoring_end_date
        self.scoring_start_date = scoring_start_date

    def __repr__(self):
        return (
            "BacktestStabilityPlotData("
            "backtest_index={0.backtest_index}, "
            "partition={0.partition}, "
            "score={0.score}, "
            "scoring_end_date={0.scoring_end_date}, "
            "scoring_start_date={0.scoring_start_date}, "
        ).format(self)
