#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.backtest_stability_plot_data import BacktestStabilityPlotData

class BacktestStabilityPlotResponse(APIObject):
    """
    Attributes
    ----------
    backtest_plot_data:[BacktestStabilityPlotData]
         An array of objects containing the details of the scores for each partition defined for the project.
    end_date:datetime
         End date of the project dataset.
    metric_name:str
         Name of the metric used to compute the scores.
    start_date:datetime
         Start date of the project dataset.
    """
    _converter = t.Dict(
        {
            t.Key("backtest_plot_data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("end_date"):  t.DateTime(),
            t.Key("metric_name"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest_plot_data,
        end_date,
        metric_name,
        start_date,
    ):
        self.backtest_plot_data = backtest_plot_data
        self.end_date = end_date
        self.metric_name = metric_name
        self.start_date = start_date

    def __repr__(self):
        return (
            "BacktestStabilityPlotResponse("
            "backtest_plot_data={0.backtest_plot_data}, "
            "end_date={0.end_date}, "
            "metric_name={0.metric_name}, "
            "start_date={0.start_date}, "
        ).format(self)
