#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BacktestStatusResponse(APIObject):
    """
    Attributes
    ----------
    index:int
         the index of the fold
    score:float, none_type
         the score of the model for this backtesting fold, if computed
    status:str
         the status of the current backtest model job
    training_duration:str
         the duration of the data used to train the model for this backtesting fold
    training_end_date:datetime
         the end date of the training for this backtesting fold
    training_row_count:int
         the number of rows used to train the model for this backtesting fold
    training_start_date:datetime
         the start date of the training for this backtesting fold
    """
    _converter = t.Dict(
        {
            t.Key("index"):  t.Int(),
            t.Key("score"):  t.Float(),
            t.Key("status"):  t.String(),
            t.Key("training_duration"):  t.String(),
            t.Key("training_end_date"):  t.DateTime(),
            t.Key("training_row_count"):  t.Int(),
            t.Key("training_start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        index,
        score,
        status,
        training_duration,
        training_end_date,
        training_row_count,
        training_start_date,
    ):
        self.index = index
        self.score = score
        self.status = status
        self.training_duration = training_duration
        self.training_end_date = training_end_date
        self.training_row_count = training_row_count
        self.training_start_date = training_start_date

    def __repr__(self):
        return (
            "BacktestStatusResponse("
            "index={0.index}, "
            "score={0.score}, "
            "status={0.status}, "
            "training_duration={0.training_duration}, "
            "training_end_date={0.training_end_date}, "
            "training_row_count={0.training_row_count}, "
            "training_start_date={0.training_start_date}, "
        ).format(self)
