#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BaseBlenderBuilderCreate(APIObject):
    """
    Attributes
    ----------
    blend_methods:[str]
         The blender method names, either GLM, ENET, AVERAGE, LGBM, TF, RF, PLS, MAE, MAEL1, MAX, or MIN.
    heuristic:str
         The blender builder heuristic name, either VALIDATION or CORRELATION.
    max_models:int
         The number of models to blend
    correlation_weight:float [optional]
         The weighting between the correlation score and accuracy score. 
    models:[str] [optional]
         The leaderboard IDs for the models to be considered for blending.. 
    top_n:int [optional]
         Use the Top N models in the leaderboard instead of a list of models.. 
    """
    _converter = t.Dict(
        {
            t.Key("blend_methods"):  t.List(t.Dict().allow_extra("*")),
            t.Key("heuristic"):  t.String(),
            t.Key("max_models"):  t.Int(),
            t.Key("correlation_weight", optional=True):  t.Float(),
            t.Key("models", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("top_n", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blend_methods,
        heuristic,
        max_models,
        correlation_weight=None,
        models=None,
        top_n=None,
    ):
        self.blend_methods = blend_methods
        self.heuristic = heuristic
        self.max_models = max_models
        self.correlation_weight = correlation_weight
        self.models = models
        self.top_n = top_n

    def __repr__(self):
        return (
            "BaseBlenderBuilderCreate("
            "blend_methods={0.blend_methods}, "
            "heuristic={0.heuristic}, "
            "max_models={0.max_models}, "
            "correlation_weight={0.correlation_weight}, "
            "models={0.models}, "
            "top_n={0.top_n}, "
        ).format(self)
