#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BaseDependencyBuildMetadataResponse(APIObject):
    """
    Attributes
    ----------
    build_end:str, none_type
         The ISO-8601 encoded time when this build completed.
    build_log_location:str, none_type
         The URL to download the build logs from this build.
    build_start:str
         The ISO-8601 encoded time when this build started.
    build_status:str
         The current status of the dependency build.
    """
    _converter = t.Dict(
        {
            t.Key("build_end"):  t.String(),
            t.Key("build_log_location"):  t.String(),
            t.Key("build_start"):  t.String(),
            t.Key("build_status"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        build_end,
        build_log_location,
        build_start,
        build_status,
    ):
        self.build_end = build_end
        self.build_log_location = build_log_location
        self.build_start = build_start
        self.build_status = build_status

    def __repr__(self):
        return (
            "BaseDependencyBuildMetadataResponse("
            "build_end={0.build_end}, "
            "build_log_location={0.build_log_location}, "
            "build_start={0.build_start}, "
            "build_status={0.build_status}, "
        ).format(self)
