#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_array_object_values import PredictionArrayObjectValues
from datarobot.models.full_api.generated.model.prediction_explanations_metadata_values import PredictionExplanationsMetadataValues
from datarobot.models.full_api.generated.model.prediction_explanations_object import PredictionExplanationsObject

class BasePredictionObject(APIObject):
    """
    Attributes
    ----------
    prediction:bool, date, datetime, dict, float, int, list, str, none_type
         In the case of a regression, the value predicted for the target in that row. In the case of any classification type, the class of the target which the row is predicted to belong to.
    row_id:int
         The row in the prediction dataset this prediction corresponds to.
    actual_value:str, none_type [optional]
         In the case of an unsupervised time series project with a dataset using ``predictionsStartDate`` and ``predictionsEndDate`` for bulk predictions and a specified actual value column, the predictions will be a json array in the same format as with a forecast point with one additional element - `actualValues`. It is the actual value in the row.. 
    forecast_distance:int, none_type [optional]
         (if time series project) The number of time units this prediction is away from the forecastPoint. The unit of time is determined by the timeUnit of the datetime partition column.. 
    forecast_point:datetime, none_type [optional]
         (if time series project) The forecastPoint of the predictions. Either provided or inferred.. 
    original_format_timestamp:str [optional]
         The timestamp of this row in the prediction dataset. Unlike the ``timestamp`` field, this field will keep the same DateTime formatting as the uploaded prediction dataset. (This column is shown if enabled by your administrator.). 
    positive_probability:float, none_type [optional]
         The probability the row belongs to the positive class. `null` for multiclass classification and regression (non binary classification) predictions.. 
    prediction_explanation_metadata:[PredictionExplanationsMetadataValues] [optional]
         Array containing algorithm-specific values. Varies depending on the value of `explanationAlgorithm`.. 
    prediction_explanations:[PredictionExplanationsObject] [optional]
         Array contains `predictionExplanation` objects. The total elements in the array are bounded by maxExplanations and feature count. It will be present only if `explanationAlgorithm` is not null (prediction explanations were requested).. 
    prediction_interval_lower_bound:float [optional]
         Present if ``includePredictionIntervals`` is True. Indicates a lower bound of the estimate of error based on test data.. 
    prediction_interval_upper_bound:float [optional]
         Present if ``includePredictionIntervals`` is True. Indicates an upper bound of the estimate of error based on test data.. 
    prediction_threshold:float [optional]
         Threshold used for binary classification in predictions.. 
    prediction_values:[PredictionArrayObjectValues] [optional]
         A list of predicted values for this row. For regression problems the label will be the name of the target column, 'Anomaly score' or ignored field. For classification problems the labels will be the names of the classes.. 
    series_id:str, none_type [optional]
         The ID of the series value for a multiseries project. For time series projects that are not a multiseries this will be a NaN.. 
    target:str, none_type [optional]
         In the case of a time series project with a dataset using predictionsStartDate and predictionsEndDate for bulk predictions, the predictions will be a json array in the same format as with a forecast point with one additional element - `target`. It is the target value in the row.. 
    timestamp:datetime [optional]
         (if time series project) The timestamp of this row in the prediction dataset.. 
    """
    _converter = t.Dict(
        {
            t.Key("prediction"):  t.Any(),
            t.Key("row_id"):  t.Int(),
            t.Key("actual_value", optional=True):  t.String(),
            t.Key("forecast_distance", optional=True):  t.Int(),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("original_format_timestamp", optional=True):  t.String(),
            t.Key("positive_probability", optional=True):  t.Float(),
            t.Key("prediction_explanation_metadata", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_explanations", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_interval_lower_bound", optional=True):  t.Float(),
            t.Key("prediction_interval_upper_bound", optional=True):  t.Float(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("prediction_values", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("series_id", optional=True):  t.String(),
            t.Key("target", optional=True):  t.String(),
            t.Key("timestamp", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        prediction,
        row_id,
        actual_value=None,
        forecast_distance=None,
        forecast_point=None,
        original_format_timestamp=None,
        positive_probability=None,
        prediction_explanation_metadata=None,
        prediction_explanations=None,
        prediction_interval_lower_bound=None,
        prediction_interval_upper_bound=None,
        prediction_threshold=None,
        prediction_values=None,
        series_id=None,
        target=None,
        timestamp=None,
    ):
        self.prediction = prediction
        self.row_id = row_id
        self.actual_value = actual_value
        self.forecast_distance = forecast_distance
        self.forecast_point = forecast_point
        self.original_format_timestamp = original_format_timestamp
        self.positive_probability = positive_probability
        self.prediction_explanation_metadata = prediction_explanation_metadata
        self.prediction_explanations = prediction_explanations
        self.prediction_interval_lower_bound = prediction_interval_lower_bound
        self.prediction_interval_upper_bound = prediction_interval_upper_bound
        self.prediction_threshold = prediction_threshold
        self.prediction_values = prediction_values
        self.series_id = series_id
        self.target = target
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "BasePredictionObject("
            "prediction={0.prediction}, "
            "row_id={0.row_id}, "
            "actual_value={0.actual_value}, "
            "forecast_distance={0.forecast_distance}, "
            "forecast_point={0.forecast_point}, "
            "original_format_timestamp={0.original_format_timestamp}, "
            "positive_probability={0.positive_probability}, "
            "prediction_explanation_metadata={0.prediction_explanation_metadata}, "
            "prediction_explanations={0.prediction_explanations}, "
            "prediction_interval_lower_bound={0.prediction_interval_lower_bound}, "
            "prediction_interval_upper_bound={0.prediction_interval_upper_bound}, "
            "prediction_threshold={0.prediction_threshold}, "
            "prediction_values={0.prediction_values}, "
            "series_id={0.series_id}, "
            "target={0.target}, "
            "timestamp={0.timestamp}, "
        ).format(self)
