#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BasicCredentials(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         The type of these credentials, 'basic' here.. defaults to "basic", must be one of ["basic", ]
    password:str
         The password for database authentication. The password is encrypted at rest and never saved / stored.
    user:str
         The username for database authentication.
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("password"):  t.String(),
            t.Key("user"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        password,
        user,
    ):
        self.credential_type = credential_type
        self.password = password
        self.user = user

    def __repr__(self):
        return (
            "BasicCredentials("
            "credential_type={0.credential_type}, "
            "password={0.password}, "
            "user={0.user}, "
        ).format(self)
