#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.time_series_properties import TimeSeriesProperties

class BasicDatasetWithSizeResponse(APIObject):
    """
    Attributes
    ----------
    categories:[str]
         An array of strings describing the intended use of the dataset.
    created_by:str
         Username of the user who created the dataset.
    creation_date:datetime
         The date when the dataset was created.
    data_persisted:bool
         If true, user is allowed to view extended data profile (which includes data statistics like min/max/median/mean, histogram, etc.) and download data. If false, download is not allowed and only the data schema (feature names and types) will be available.
    dataset_id:str
         The ID of this dataset.
    dataset_size:int
         The size of the dataset as a CSV in bytes.
    is_data_engine_eligible:bool
         Whether this dataset can be a data source of a data engine query.
    is_latest_version:bool
         Whether this dataset version is the latest version of this dataset.
    is_snapshot:bool
         Whether the dataset is an immutable snapshot of data which has previously been retrieved and saved to DataRobot.
    name:str
         The name of this dataset in the catalog.
    processing_state:str
         Current ingestion process state of dataset.
    row_count:int
         The number of rows in the dataset.
    time_series_properties:TimeSeriesProperties
        
    version_id:str
         The object ID of the catalog_version the dataset belongs to.
    """
    _converter = t.Dict(
        {
            t.Key("categories"):  t.List(t.Dict().allow_extra("*")),
            t.Key("created_by"):  t.String(),
            t.Key("creation_date"):  t.DateTime(),
            t.Key("data_persisted"):  t.Bool(),
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_size"):  t.Int(),
            t.Key("is_data_engine_eligible"):  t.Bool(),
            t.Key("is_latest_version"):  t.Bool(),
            t.Key("is_snapshot"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("processing_state"):  t.String(),
            t.Key("row_count"):  t.Int(),
            t.Key("time_series_properties"):  t.Any(),
            t.Key("version_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        categories,
        created_by,
        creation_date,
        data_persisted,
        dataset_id,
        dataset_size,
        is_data_engine_eligible,
        is_latest_version,
        is_snapshot,
        name,
        processing_state,
        row_count,
        time_series_properties,
        version_id,
    ):
        self.categories = categories
        self.created_by = created_by
        self.creation_date = creation_date
        self.data_persisted = data_persisted
        self.dataset_id = dataset_id
        self.dataset_size = dataset_size
        self.is_data_engine_eligible = is_data_engine_eligible
        self.is_latest_version = is_latest_version
        self.is_snapshot = is_snapshot
        self.name = name
        self.processing_state = processing_state
        self.row_count = row_count
        self.time_series_properties = time_series_properties
        self.version_id = version_id

    def __repr__(self):
        return (
            "BasicDatasetWithSizeResponse("
            "categories={0.categories}, "
            "created_by={0.created_by}, "
            "creation_date={0.creation_date}, "
            "data_persisted={0.data_persisted}, "
            "dataset_id={0.dataset_id}, "
            "dataset_size={0.dataset_size}, "
            "is_data_engine_eligible={0.is_data_engine_eligible}, "
            "is_latest_version={0.is_latest_version}, "
            "is_snapshot={0.is_snapshot}, "
            "name={0.name}, "
            "processing_state={0.processing_state}, "
            "row_count={0.row_count}, "
            "time_series_properties={0.time_series_properties}, "
            "version_id={0.version_id}, "
        ).format(self)
