#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BatchFeatureTransform(APIObject):
    """
    Attributes
    ----------
    parent_names:[str]
         List of feature names that will be transformed into a new variable type.
    variable_type:str
         The type of the new feature. Must be one of `text`, `categorical` (Deprecated in version v2.21), `numeric`, or `categoricalInt`.
    prefix:str [optional]
         The string that will preface all feature names. Optional if suffix is present. (One or both are required.). 
    suffix:str [optional]
         The string that will be appended at the end to all feature names. Optional if prefix is present. (One or both are required.). 
    """
    _converter = t.Dict(
        {
            t.Key("parent_names"):  t.List(t.Dict().allow_extra("*")),
            t.Key("variable_type"):  t.String(),
            t.Key("prefix", optional=True):  t.String(),
            t.Key("suffix", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        parent_names,
        variable_type,
        prefix=None,
        suffix=None,
    ):
        self.parent_names = parent_names
        self.variable_type = variable_type
        self.prefix = prefix
        self.suffix = suffix

    def __repr__(self):
        return (
            "BatchFeatureTransform("
            "parent_names={0.parent_names}, "
            "variable_type={0.variable_type}, "
            "prefix={0.prefix}, "
            "suffix={0.suffix}, "
        ).format(self)
