#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BatchPredictionJobCSVSettings(APIObject):
    """
    Attributes
    ----------
    delimiter:bool, date, datetime, dict, float, int, list, str, none_type
         CSV fields are delimited by this character. Use the string \"tab\" to denote TSV (TAB separated values).
    encoding:str
         The encoding to be used for intake and output. For example (but not limited to): \"shift_jis\", \"latin_1\" or \"mskanji\".. defaults to "utf-8"
    quotechar:str
         Fields containing the delimiter or newlines must be quoted using this character.. defaults to "\""
    """
    _converter = t.Dict(
        {
            t.Key("delimiter"):  t.Any(),
            t.Key("encoding"):  t.String(),
            t.Key("quotechar"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        delimiter,
        encoding,
        quotechar,
    ):
        self.delimiter = delimiter
        self.encoding = encoding
        self.quotechar = quotechar

    def __repr__(self):
        return (
            "BatchPredictionJobCSVSettings("
            "delimiter={0.delimiter}, "
            "encoding={0.encoding}, "
            "quotechar={0.quotechar}, "
        ).format(self)
