#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.batch_prediction_created_by import BatchPredictionCreatedBy
from datarobot.models.full_api.generated.model.batch_prediction_job_spec import BatchPredictionJobSpec
from datarobot.models.full_api.generated.model.schedule import Schedule

class BatchPredictionJobDefinitionsResponse(APIObject):
    """
    Attributes
    ----------
    batch_prediction_job:BatchPredictionJobSpec
        
    created:datetime
         When was this job created
    created_by:BatchPredictionCreatedBy
        
    enabled:bool
         If this job definition is enabled as a scheduled job.. defaults to False
    id:str
         The ID of the Batch Prediction job definition
    last_started_job_status:str, none_type
         The status of the latest job launched to the queue (if any).
    last_started_job_time:datetime, none_type
         The last time (if any) a job was launched.
    name:str
         A human-readable name for the definition, must be unique across organisations
    updated:datetime
         When was this job last updated
    updated_by:BatchPredictionCreatedBy
        
    last_failed_run_time:datetime, none_type [optional]
         Last time this job had a failed run. 
    last_scheduled_run_time:datetime, none_type [optional]
         Last time this job was scheduled to run (though not guaranteed it actually ran at that time). 
    last_successful_run_time:datetime, none_type [optional]
         Last time this job had a successful run. 
    next_scheduled_run_time:datetime, none_type [optional]
         Next time this job is scheduled to run. 
    schedule:Schedule [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("batch_prediction_job"):  t.Any(),
            t.Key("created"):  t.DateTime(),
            t.Key("created_by"):  t.Any(),
            t.Key("enabled"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("last_started_job_status"):  t.String(),
            t.Key("last_started_job_time"):  t.DateTime(),
            t.Key("name"):  t.String(),
            t.Key("updated"):  t.DateTime(),
            t.Key("updated_by"):  t.Any(),
            t.Key("last_failed_run_time", optional=True):  t.DateTime(),
            t.Key("last_scheduled_run_time", optional=True):  t.DateTime(),
            t.Key("last_successful_run_time", optional=True):  t.DateTime(),
            t.Key("next_scheduled_run_time", optional=True):  t.DateTime(),
            t.Key("schedule", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        batch_prediction_job,
        created,
        created_by,
        enabled,
        id,
        last_started_job_status,
        last_started_job_time,
        name,
        updated,
        updated_by,
        last_failed_run_time=None,
        last_scheduled_run_time=None,
        last_successful_run_time=None,
        next_scheduled_run_time=None,
        schedule=None,
    ):
        self.batch_prediction_job = batch_prediction_job
        self.created = created
        self.created_by = created_by
        self.enabled = enabled
        self.id = id
        self.last_started_job_status = last_started_job_status
        self.last_started_job_time = last_started_job_time
        self.name = name
        self.updated = updated
        self.updated_by = updated_by
        self.last_failed_run_time = last_failed_run_time
        self.last_scheduled_run_time = last_scheduled_run_time
        self.last_successful_run_time = last_successful_run_time
        self.next_scheduled_run_time = next_scheduled_run_time
        self.schedule = schedule

    def __repr__(self):
        return (
            "BatchPredictionJobDefinitionsResponse("
            "batch_prediction_job={0.batch_prediction_job}, "
            "created={0.created}, "
            "created_by={0.created_by}, "
            "enabled={0.enabled}, "
            "id={0.id}, "
            "last_started_job_status={0.last_started_job_status}, "
            "last_started_job_time={0.last_started_job_time}, "
            "name={0.name}, "
            "updated={0.updated}, "
            "updated_by={0.updated_by}, "
            "last_failed_run_time={0.last_failed_run_time}, "
            "last_scheduled_run_time={0.last_scheduled_run_time}, "
            "last_successful_run_time={0.last_successful_run_time}, "
            "next_scheduled_run_time={0.next_scheduled_run_time}, "
            "schedule={0.schedule}, "
        ).format(self)
