#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.batch_prediction_job_csv_settings import BatchPredictionJobCSVSettings
from datarobot.models.full_api.generated.model.batch_prediction_job_prediction_instance import BatchPredictionJobPredictionInstance
from datarobot.models.full_api.generated.model.schedule import Schedule

class BatchPredictionJobDefinitionsUpdate(APIObject):
    """
    Attributes
    ----------
    abort_on_error:bool [optional]
         Should this job abort if too many errors are encountered.  if omitted the server will use the default value of True
    chunk_size:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.. 
    column_names_remapping:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Remap (rename or remove columns from) the output from this job. 
    csv_settings:BatchPredictionJobCSVSettings [optional]
         
    deployment_id:str [optional]
         The ID of the deployment used for scoring this job. 
    disable_row_level_error_handling:bool [optional]
         Skip row by row error handling.  if omitted the server will use the default value of False
    enabled:bool [optional]
         If this job definition is enabled as a scheduled job. Optional if no schedule is supplied.. 
    explanation_algorithm:str [optional]
         Which algorithm will be used to calculate prediction explanations. 
    include_prediction_status:bool [optional]
         Include prediction status column in the output.  if omitted the server will use the default value of False
    include_probabilities:bool [optional]
         Include probabilities for all classes.  if omitted the server will use the default value of True
    include_probabilities_classes:[str] [optional]
         Include only probabilities for these specific class names..  if omitted the server will use the default value of []
    intake_settings:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The intake option configured for this job. 
    max_explanations:int [optional]
         Number of explanations requested. Will be ordered by strength..  if omitted the server will use the default value of 0
    name:str [optional]
         A human-readable name for the definition, must be unique across organisations, if left out the backend will generate one for you.. 
    num_concurrent:int [optional]
         Number of simultaneous requests to run against the prediction instance. 
    output_settings:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The output option configured for this job. 
    passthrough_columns:[str] [optional]
         Pass through columns from the original dataset. 
    passthrough_columns_set:str [optional]
         Pass through all columns from the original dataset.  if omitted the server will use the default value of "all"
    pinned_model_id:str [optional]
         Specify a model ID used for scoring. 
    prediction_instance:BatchPredictionJobPredictionInstance [optional]
         
    prediction_warning_enabled:bool, none_type [optional]
         Enable prediction warnings.. 
    schedule:Schedule [optional]
         
    skip_drift_tracking:bool [optional]
         Skip drift tracking for this job..  if omitted the server will use the default value of False
    threshold_high:float [optional]
         Compute explanations for predictions above this threshold. 
    threshold_low:float [optional]
         Compute explanations for predictions below this threshold. 
    timeseries_settings:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Time Series settings included of this job is a Time Series job.. 
    """
    _converter = t.Dict(
        {
            t.Key("abort_on_error", optional=True):  t.Bool(),
            t.Key("chunk_size", optional=True):  t.Any(),
            t.Key("column_names_remapping", optional=True):  t.Any(),
            t.Key("csv_settings", optional=True):  t.Any(),
            t.Key("deployment_id", optional=True):  t.String(),
            t.Key("disable_row_level_error_handling", optional=True):  t.Bool(),
            t.Key("enabled", optional=True):  t.Bool(),
            t.Key("explanation_algorithm", optional=True):  t.String(),
            t.Key("include_prediction_status", optional=True):  t.Bool(),
            t.Key("include_probabilities", optional=True):  t.Bool(),
            t.Key("include_probabilities_classes", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("intake_settings", optional=True):  t.Any(),
            t.Key("max_explanations", optional=True):  t.Int(),
            t.Key("name", optional=True):  t.String(),
            t.Key("num_concurrent", optional=True):  t.Int(),
            t.Key("output_settings", optional=True):  t.Any(),
            t.Key("passthrough_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("passthrough_columns_set", optional=True):  t.String(),
            t.Key("pinned_model_id", optional=True):  t.String(),
            t.Key("prediction_instance", optional=True):  t.Any(),
            t.Key("prediction_warning_enabled", optional=True):  t.Bool(),
            t.Key("schedule", optional=True):  t.Any(),
            t.Key("skip_drift_tracking", optional=True):  t.Bool(),
            t.Key("threshold_high", optional=True):  t.Float(),
            t.Key("threshold_low", optional=True):  t.Float(),
            t.Key("timeseries_settings", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        abort_on_error=None,
        chunk_size=None,
        column_names_remapping=None,
        csv_settings=None,
        deployment_id=None,
        disable_row_level_error_handling=None,
        enabled=None,
        explanation_algorithm=None,
        include_prediction_status=None,
        include_probabilities=None,
        include_probabilities_classes=None,
        intake_settings=None,
        max_explanations=None,
        name=None,
        num_concurrent=None,
        output_settings=None,
        passthrough_columns=None,
        passthrough_columns_set=None,
        pinned_model_id=None,
        prediction_instance=None,
        prediction_warning_enabled=None,
        schedule=None,
        skip_drift_tracking=None,
        threshold_high=None,
        threshold_low=None,
        timeseries_settings=None,
    ):
        self.abort_on_error = abort_on_error
        self.chunk_size = chunk_size
        self.column_names_remapping = column_names_remapping
        self.csv_settings = csv_settings
        self.deployment_id = deployment_id
        self.disable_row_level_error_handling = disable_row_level_error_handling
        self.enabled = enabled
        self.explanation_algorithm = explanation_algorithm
        self.include_prediction_status = include_prediction_status
        self.include_probabilities = include_probabilities
        self.include_probabilities_classes = include_probabilities_classes
        self.intake_settings = intake_settings
        self.max_explanations = max_explanations
        self.name = name
        self.num_concurrent = num_concurrent
        self.output_settings = output_settings
        self.passthrough_columns = passthrough_columns
        self.passthrough_columns_set = passthrough_columns_set
        self.pinned_model_id = pinned_model_id
        self.prediction_instance = prediction_instance
        self.prediction_warning_enabled = prediction_warning_enabled
        self.schedule = schedule
        self.skip_drift_tracking = skip_drift_tracking
        self.threshold_high = threshold_high
        self.threshold_low = threshold_low
        self.timeseries_settings = timeseries_settings

    def __repr__(self):
        return (
            "BatchPredictionJobDefinitionsUpdate("
            "abort_on_error={0.abort_on_error}, "
            "chunk_size={0.chunk_size}, "
            "column_names_remapping={0.column_names_remapping}, "
            "csv_settings={0.csv_settings}, "
            "deployment_id={0.deployment_id}, "
            "disable_row_level_error_handling={0.disable_row_level_error_handling}, "
            "enabled={0.enabled}, "
            "explanation_algorithm={0.explanation_algorithm}, "
            "include_prediction_status={0.include_prediction_status}, "
            "include_probabilities={0.include_probabilities}, "
            "include_probabilities_classes={0.include_probabilities_classes}, "
            "intake_settings={0.intake_settings}, "
            "max_explanations={0.max_explanations}, "
            "name={0.name}, "
            "num_concurrent={0.num_concurrent}, "
            "output_settings={0.output_settings}, "
            "passthrough_columns={0.passthrough_columns}, "
            "passthrough_columns_set={0.passthrough_columns_set}, "
            "pinned_model_id={0.pinned_model_id}, "
            "prediction_instance={0.prediction_instance}, "
            "prediction_warning_enabled={0.prediction_warning_enabled}, "
            "schedule={0.schedule}, "
            "skip_drift_tracking={0.skip_drift_tracking}, "
            "threshold_high={0.threshold_high}, "
            "threshold_low={0.threshold_low}, "
            "timeseries_settings={0.timeseries_settings}, "
        ).format(self)
