#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BatchPredictionJobPredictionInstance(APIObject):
    """
    Attributes
    ----------
    host_name:str
         Override the default host name of the deployment with this.
    ssl_enabled:bool
         Use SSL (HTTPS) when communicating with the overriden prediction server.. defaults to True
    api_key:str [optional]
         By default, prediction requests will use the API key of the user that created the job. This allows you to make requests on behalf of other users.. 
    datarobot_key:str [optional]
         If running a job against a prediction instance in the Managed AI Cloud, you must provide the organization level DataRobot-Key.. 
    """
    _converter = t.Dict(
        {
            t.Key("host_name"):  t.String(),
            t.Key("ssl_enabled"):  t.Bool(),
            t.Key("api_key", optional=True):  t.String(),
            t.Key("datarobot_key", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        host_name,
        ssl_enabled,
        api_key=None,
        datarobot_key=None,
    ):
        self.host_name = host_name
        self.ssl_enabled = ssl_enabled
        self.api_key = api_key
        self.datarobot_key = datarobot_key

    def __repr__(self):
        return (
            "BatchPredictionJobPredictionInstance("
            "host_name={0.host_name}, "
            "ssl_enabled={0.ssl_enabled}, "
            "api_key={0.api_key}, "
            "datarobot_key={0.datarobot_key}, "
        ).format(self)
