#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.batch_prediction_created_by import BatchPredictionCreatedBy
from datarobot.models.full_api.generated.model.batch_prediction_job_definition_response import BatchPredictionJobDefinitionResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_links import BatchPredictionJobLinks
from datarobot.models.full_api.generated.model.batch_prediction_job_spec import BatchPredictionJobSpec

class BatchPredictionJobResponse(APIObject):
    """
    Attributes
    ----------
    created:datetime
         When was this job created
    created_by:BatchPredictionCreatedBy
        
    elapsed_time_sec:int
         Number of seconds the job has been processing for
    failed_rows:int
         Number of rows that have failed scoring
    id:str
         The ID of the Batch Prediction job
    job_intake_size:int, none_type
         Number of bytes in the intake dataset for this job
    job_output_size:int, none_type
         Number of bytes in the output dataset for this job
    job_spec:BatchPredictionJobSpec
        
    links:BatchPredictionJobLinks
        
    logs:[str]
         The job log.
    percentage_completed:float
         Indicates job progress which is based on number of already processed rows in dataset
    queued:bool
         The job has been put on the queue for execution.
    scored_rows:int
         Number of rows that have been successfully scored
    skipped_rows:int
         Number of rows that have been skipped during scoring. May contain non-zero value only in time-series predictions case if provided dataset contains more than required historical rows.
    status:str
         The current job status
    status_details:str
         Explanation for current status
    batch_prediction_job_definition:BatchPredictionJobDefinitionResponse [optional]
         
    hidden:datetime [optional]
         When was this job was hidden last, blank if visible. 
    intake_dataset_display_name:str, none_type [optional]
         If applicable (e.g. for AI catalog), will contain the dataset name used for the intake dataset.. 
    queue_position:int, none_type [optional]
         To ensure a dedicated prediction instance is not overloaded, only one job will be run against it at a time. This is the number of jobs that are awaiting processing before this job start running. May not be available in all environments.. 
    results_deleted:bool [optional]
         Indicates if the job was subject to garbage collection and had its artifacts deleted (output files, if any, and scoring data on local storage). 
    source:str [optional]
         Source from which batch job was started. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.DateTime(),
            t.Key("created_by"):  t.Any(),
            t.Key("elapsed_time_sec"):  t.Int(),
            t.Key("failed_rows"):  t.Int(),
            t.Key("id"):  t.String(),
            t.Key("job_intake_size"):  t.Int(),
            t.Key("job_output_size"):  t.Int(),
            t.Key("job_spec"):  t.Any(),
            t.Key("links"):  t.Any(),
            t.Key("logs"):  t.List(t.Dict().allow_extra("*")),
            t.Key("percentage_completed"):  t.Float(),
            t.Key("queued"):  t.Bool(),
            t.Key("scored_rows"):  t.Int(),
            t.Key("skipped_rows"):  t.Int(),
            t.Key("status"):  t.String(),
            t.Key("status_details"):  t.String(),
            t.Key("batch_prediction_job_definition", optional=True):  t.Any(),
            t.Key("hidden", optional=True):  t.DateTime(),
            t.Key("intake_dataset_display_name", optional=True):  t.String(),
            t.Key("queue_position", optional=True):  t.Int(),
            t.Key("results_deleted", optional=True):  t.Bool(),
            t.Key("source", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        created_by,
        elapsed_time_sec,
        failed_rows,
        id,
        job_intake_size,
        job_output_size,
        job_spec,
        links,
        logs,
        percentage_completed,
        queued,
        scored_rows,
        skipped_rows,
        status,
        status_details,
        batch_prediction_job_definition=None,
        hidden=None,
        intake_dataset_display_name=None,
        queue_position=None,
        results_deleted=None,
        source=None,
    ):
        self.created = created
        self.created_by = created_by
        self.elapsed_time_sec = elapsed_time_sec
        self.failed_rows = failed_rows
        self.id = id
        self.job_intake_size = job_intake_size
        self.job_output_size = job_output_size
        self.job_spec = job_spec
        self.links = links
        self.logs = logs
        self.percentage_completed = percentage_completed
        self.queued = queued
        self.scored_rows = scored_rows
        self.skipped_rows = skipped_rows
        self.status = status
        self.status_details = status_details
        self.batch_prediction_job_definition = batch_prediction_job_definition
        self.hidden = hidden
        self.intake_dataset_display_name = intake_dataset_display_name
        self.queue_position = queue_position
        self.results_deleted = results_deleted
        self.source = source

    def __repr__(self):
        return (
            "BatchPredictionJobResponse("
            "created={0.created}, "
            "created_by={0.created_by}, "
            "elapsed_time_sec={0.elapsed_time_sec}, "
            "failed_rows={0.failed_rows}, "
            "id={0.id}, "
            "job_intake_size={0.job_intake_size}, "
            "job_output_size={0.job_output_size}, "
            "job_spec={0.job_spec}, "
            "links={0.links}, "
            "logs={0.logs}, "
            "percentage_completed={0.percentage_completed}, "
            "queued={0.queued}, "
            "scored_rows={0.scored_rows}, "
            "skipped_rows={0.skipped_rows}, "
            "status={0.status}, "
            "status_details={0.status_details}, "
            "batch_prediction_job_definition={0.batch_prediction_job_definition}, "
            "hidden={0.hidden}, "
            "intake_dataset_display_name={0.intake_dataset_display_name}, "
            "queue_position={0.queue_position}, "
            "results_deleted={0.results_deleted}, "
            "source={0.source}, "
        ).format(self)
