#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class BatchPredictionJobTimeSeriesSettingsForecast(APIObject):
    """
    Attributes
    ----------
    type:str
         Forecast mode makes predictions using forecastPoint or rows in the dataset without target.. defaults to "forecast", must be one of ["forecast", ]
    forecast_point:datetime [optional]
         Used for forecast predictions in order to override the inferred forecast point from the dataset.. 
    relax_known_in_advance_features_check:bool [optional]
         If activated, missing values in the known in advance features are allowed in the forecast window at prediction time. If omitted or false, missing values are not allowed..  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("type"):  t.String(),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("relax_known_in_advance_features_check", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        type,
        forecast_point=None,
        relax_known_in_advance_features_check=None,
    ):
        self.type = type
        self.forecast_point = forecast_point
        self.relax_known_in_advance_features_check = relax_known_in_advance_features_check

    def __repr__(self):
        return (
            "BatchPredictionJobTimeSeriesSettingsForecast("
            "type={0.type}, "
            "forecast_point={0.forecast_point}, "
            "relax_known_in_advance_features_check={0.relax_known_in_advance_features_check}, "
        ).format(self)
